unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ComCtrls, ExtCtrls, ActnList, StdCtrls, Grids, DBGrids,
  SqlExpr;  

type
  TFMain = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    SpeedButton1: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    Label1: TLabel;
    Shape: TShape;
    cbTables: TComboBox;
    Panel2: TPanel;
    Memo1: TMemo;
    Panel3: TPanel;
    DBGrid1: TDBGrid;
    LabelPolaTabeli: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cbTablesChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure   pokaz_pola_tabeli();
    procedure   szczegoly_tabeli(nazwa_tabeli: String);

    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
  end;

var
  FMain: TFMain;

implementation
{$R *.dfm}
Uses
   DataModule;

constructor TFMain.Create(AOwner: TComponent);
var
   kk     : Integer;
   tabela : String;

begin
   inherited Create(Aowner);
end;

destructor TFMain.Destroy();
begin
   inherited Destroy();
end;

procedure TFMain.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFMain.FormActivate(Sender: TObject);
begin
   if DM.SQLConnection.Connected  = True then begin
      Shape.Brush.Color := clGreen;
   end
   else begin
      Shape.Brush.Color := clRed;
   end;

   DM.SQLConnection.GetTableNames(cbTables.Items);
end;

procedure TFMain.cbTablesChange(Sender: TObject);
begin
   Pokaz_pola_tabeli();
end;

procedure TFMain.Pokaz_pola_tabeli();
var
   poz          : integer;
   nazwa_tabeli : String;
begin
   poz          := cbTables.ItemIndex;
   nazwa_tabeli := cbTables.Items[poz];

   Memo1.Clear();
   DM.SQLDataSet.CommandText := nazwa_tabeli;
   DM.SQLDataSet.GetFieldNames(Memo1.Lines);

   szczegoly_tabeli(nazwa_tabeli);
end;

procedure TFMain.szczegoly_tabeli(nazwa_tabeli: String);
begin
   LabelPolaTabeli.Caption := 'Pola tabeli: ' + nazwa_tabeli;

   DM.SQLConnection.Close();
   DM.SQLDataSet.Close();
   DM.SQLDataSet_schema.Close();
   DM.ClientDataSet.Close();


   // DM.SQLDataSet_schema.Close();
   // DM.ClientDataSet1.Close();

   DM.SQLDataSet_schema.SetSchemaInfo(stColumns, nazwa_tabeli, '');

   DM.SQLDataSet_schema.Open();
   DM.ClientDataSet.Open();
end;

end.
